// Adjust heights of elements
function adjustHeights() {
    const viewportHeight = window.innerHeight;
    const footerHeight = document.querySelector('footer').offsetHeight;
    const headerHeight = document.querySelector('header').offsetHeight;
    const availableHeight = viewportHeight - footerHeight - headerHeight;

    // const leftBox = document.querySelector('.left-section .box');
    const pieBoxes = document.querySelectorAll('.pie-box');

    // leftBox.style.height = `${availableHeight - 130}px`;

    pieBoxes.forEach(box => {
        box.style.height = `${(availableHeight / 2) - 5}px`; // -5px to account for margins and padding
    });
}

//Dynamic data for chart code start 

// Render pie charts
function renderPieCharts() {
    // Get dynamic data from the HTML
    const violationCount = parseInt(document.getElementById('violationCount').innerText, 10);
    const incompleteCount = parseInt(document.getElementById('incompleteCount').innerText, 10);
    const inapplicableCount = parseInt(document.getElementById('inapplicableCount').innerText, 10);
    const passesCount = parseInt(document.getElementById('passesCount').innerText, 10);

    // Create the pie data dynamically
    const pieData = {
        labels: ['Violations', 'Incomplete', 'Inapplicable', 'Passes'],
        datasets: [{
            data: [violationCount, incompleteCount, inapplicableCount, passesCount],
            backgroundColor: [
                '#ffe1e6', // Violations (matches .violations-info-box)
                '#fff5df', // Incomplete (matches .incomplete-info-box)
                '#daecfc', // Inapplicable (matches .inapplicable-info-box)
                '#ddf3f2'  // Passes (matches .passes-info-box)
            ],
            borderColor: [
                '#ffe1e6', // Violations border
                '#fff5df', // Incomplete border
                '#daecfc', // Inapplicable border
                '#ddf3f2'  // Passes border
            ],
            borderWidth: 1
        }]
    };

    const options = {
        maintainAspectRatio: false,
        legend: {
            display: false // Disable default legend
        }
    };

    const pieCharts = document.querySelectorAll('.pie-chart');
    pieCharts.forEach(chart => {
        const myChart = new Chart(chart, {
            type: 'pie',
            data: pieData,
            options: options
        });
       
        // Create a custom legend
        const legendContainer = chart.parentElement.querySelector('.chart-legend');
        legendContainer.innerHTML = myChart.generateLegend();
    });
}

//dynamic data chart code end here

/*
// Render pie charts
function renderPieCharts() {
    const pieData = {
        labels: ['Violations', 'Incomplete', 'Inapplicable', 'Passes'],
        datasets: [{
            data: [52, 19, 73, 56],
            backgroundColor: [
                'rgba(255, 99, 132, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(255, 206, 86, 0.2)',
                'rgba(75, 192, 192, 0.2)'
            ],
            borderColor: [
                'rgba(255, 99, 132, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(255, 206, 86, 1)',
                'rgba(75, 192, 192, 1)'
            ],
            borderWidth: 1
        }]
    };

    const options = {
        maintainAspectRatio: false,
        legend: {
            display: false // Disable default legend
        }
    };

    const pieCharts = document.querySelectorAll('.pie-chart');
    pieCharts.forEach(chart => {
        const myChart = new Chart(chart, {
            type: 'pie',
            data: pieData,
            options: options
        });
       
        // Create a custom legend
        const legendContainer = chart.parentElement.querySelector('.chart-legend');
        legendContainer.innerHTML = myChart.generateLegend();
    });
}

*/

// Initialize everything on window load
window.addEventListener('load', () => {
    adjustHeights();
    renderPieCharts();
});

// Adjust heights on window resize
window.addEventListener('resize', adjustHeights);

// Detail section hide show
document.addEventListener('DOMContentLoaded', function() {
    // Set the first .details-section as active by default
   
    document.querySelectorAll(".custom-tab-item").forEach(function(item) { 
        const listItems = item.querySelectorAll('.list-group-item-action');
        if (listItems.length > 0) {
            listItems[0].classList.add('active');
        }
        const detailsSections = item.querySelectorAll('.detail-main');
        if (detailsSections.length > 0) {
            detailsSections[0].classList.add('active');
        }
    });


    
    

    document.querySelectorAll("#products").forEach(function(item) { 
        const detailsContent = item.querySelectorAll('.body-content');
        if (detailsContent.length > 0) {
            detailsContent[0].classList.add('active');
        }
    });
    
    jQuery('.main-product').each(function(index){
        jQuery(this).addClass('mainProduct-' + index);
    })

    // Set impact badge colors
    setImpactBadgeByText();
});

// List item click event
document.querySelectorAll(".main-product").forEach(function(items) {
    items.querySelectorAll(".list-group-item-action").forEach(function(item) {
        item.addEventListener('click', function() {
            document.querySelectorAll(".custom-tab-item.active").forEach(function(item) { 
                item.querySelectorAll(".list-group-item-action").forEach(function(sibling) {
                    sibling.classList.remove('active');
                });
            });
            this.classList.add('active');

            const id = this.getAttribute('data-target');
                document.querySelectorAll(".custom-tab-item.active").forEach(function(item) { 
                    item.querySelectorAll('.detail-main').forEach(function(detail) {
                    detail.classList.remove('active');
                });
            });
            jQuery('.'+id).addClass('active');
            // document.getElementById(id).classList.add('active');
        });
    });
});


//Tab Click here 


// Initialize tooltips
(() => {
    'use strict'
    const tooltipTriggerList = Array.from(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    tooltipTriggerList.forEach(tooltipTriggerEl => {
        new bootstrap.Tooltip(tooltipTriggerEl)
    })
})();

// ADA items button click event
document.querySelectorAll(".main-product").forEach(function(item) {
    item.querySelectorAll(".ada-items-btn").forEach(function(btn) {
        btn.addEventListener('click', function() {
            item.querySelectorAll(".ada-items-btn.active").forEach(function(activeBtn) {
                activeBtn.classList.remove('active');
            });
            this.classList.add("active");
            const id = this.getAttribute('data-tab');
            item.querySelectorAll(".custom-tab-item.active").forEach(function(activeTab) {
                activeTab.classList.remove('active');
            });
            jQuery('.'+id).addClass('active');
            // item.getElementById(id).classList.add("active");
        });
    });
});



//List item active remove


// Set badge color based on text content
function setImpactBadgeByText() {
    // Select all elements with the class 'badge'
    const badges = document.querySelectorAll('.badge');

    // Iterate through each element
    badges.forEach(function(badge) {
        // Trim and lowercase the text content
        const impactText = badge.textContent.trim().toLowerCase();

        // Debug: Output the text content being processed
        console.log("Processing badge with text:", impactText);

        // Remove all potential impact classes
        badge.classList.remove('badge-critical', 'badge-serious', 'badge-moderate', 'badge-minor', 'badge-null');

        // Apply the appropriate class based on the text content
        switch (impactText) {
            case 'critical':
                badge.classList.add('badge-critical');
                break;
            case 'serious':
                badge.classList.add('badge-serious');
                break;
            case 'moderate':
                badge.classList.add('badge-moderate');
                break;
            case 'minor':
                badge.classList.add('badge-minor');
                break;
            default:
                badge.classList.add('badge-null');
                break;
        }

        // Debug: Output the applied class
        console.log("Applied class:", badge.className);
    });
}

// Call the function to set the badge color based on its text
document.addEventListener('DOMContentLoaded', setImpactBadgeByText);


// ADA items button click event
var selectevent = true;
var dataValues = "0";
document.querySelectorAll(".nav-left .nav-item .nav-link").forEach(function(btn) {
    btn.addEventListener('click', function() {
        document.querySelectorAll(".nav-left .nav-item .nav-link.active").forEach(function(activeBtn) {
            activeBtn.classList.remove('active');
        });
        this.classList.add("active");
        const id = this.getAttribute('data-tab');
        document.querySelectorAll("main.active").forEach(function(activeTab) {
            activeTab.classList.remove('active');
        });
        // if(selectevent == true){
        //     document.getElementById(id).classList.add("active");
        // }else{
        //     console.log(dataValues)
        //     // document.querySelectorAll('.mainProduct-' + dataValues).classList.add("active");
        //     jQuery('.mainProduct-' + dataValues).addClass('active');
        // }
        if(id === "products"){
            
            
            if(selectevent == true){
                jQuery('.mainProduct-' + dataValues).addClass('active');

                jQuery('.form-select').on('change', function(){
                    // Get the selected option
                    var selectedOption = jQuery(this).find('option:selected');
                    
                    // Get the data-values attribute from the selected option
                    dataValues = selectedOption.data('values');
                    
                    // Log the data-values (e.g., "page_0") to the console
                   
                    jQuery('.main-product').removeClass('active');
                    jQuery('.mainProduct-' + dataValues).addClass('active');
                    selectevent = false;
                });
            }else{
                jQuery('.mainProduct-' + dataValues).addClass('active');
            }
            // jQuery('.mainProduct-' + dataValues).addClass('active');
             document.querySelector('body').classList.add("active-product");
        }else{
            document.getElementById(id).classList.add("active");
            document.querySelector('body').classList.remove("active-product");
        }

    });
});


